//=============================================================
// ZuluTime.cpp
// A demonstration of the Bridge Design Pattern.  This class
//   defines a sub-class of the Abstraction.
// Author: Dr. Rick Coleman
//=============================================================
#include "ZuluTime.h"
#include "ZuluTimeImp.h"

//----------------------------
// Constructor
//----------------------------
ZuluTime::ZuluTime(int hr, int min, int zone) 
{
	cout << "\tZuluTime constructor is creating an instance of ZuluTimeImp\n";
    m_Imp = new ZuluTimeImp(hr, min, zone);
}

//----------------------------
// Destructor
//----------------------------
ZuluTime::~ZuluTime() 
{
    delete m_Imp;
}

//----------------------------
// Tell the time
//----------------------------
void ZuluTime::tell() 
{
	cout << "\tZuluTime instance is calling its ZuluTimeImp->tell()\n";
    m_Imp->tell();
}