//=============================================================
// Time.cpp
// A demonstration of the Bridge Design Pattern.  This class
//   defines the parent class of the Abstraction.
// Author: Dr. Rick Coleman
//=============================================================
#include "Time.h"
#include "TimeImp.h"

//----------------------------
// Default Constructor
//----------------------------
Time::Time() 
{
}

//----------------------------
// Constructor
//----------------------------
Time::Time(int hr, int min) 
{
	cout << "\tTime constructor is creating an instance of TimeImp\n";
    m_Imp = new TimeImp(hr, min);
}

//----------------------------
// Destructor
//----------------------------
Time::~Time() 
{
    delete m_Imp;
}

//----------------------------
// Tell the time
//----------------------------
void Time::tell() 
{
	cout << "\tTime instance is calling its TimeImp->tell()\n";
    m_Imp->tell();
}
