//=============================================================
// CivilianTime.cpp
// A demonstration of the Bridge Design Pattern.  This class
//   defines a sub-class of the Abstraction.
// Author: Dr. Rick Coleman
//=============================================================
#include "CivilianTime.h"
#include "CivilianTimeImp.h"

//----------------------------
// Constructor
//----------------------------
CivilianTime::CivilianTime(int hr, int min, int pm) 
{
	cout << "\tCivilianTime constructor is creating an instance of CivilianTimeImp\n";
    m_Imp = new CivilianTimeImp(hr, min, pm);
}

//----------------------------
// Destructor
//----------------------------
CivilianTime::~CivilianTime() 
{
    delete m_Imp;
}

//----------------------------
// Tell the time
//----------------------------
void CivilianTime::tell() 
{
	cout << "\tCivilianTime instance is calling its CivilianTimeImp->tell()\n";
    m_Imp->tell();
}