//=============================================================
// BridgeMain.cpp
// A demonstration of the Bridge design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include <iostream>
using namespace std;

#include "Time.h"
#include "CivilianTime.h"
#include "ZuluTime.h"

// SEE NOTES BELOW

void main()
{
 	cout << "=== Demonstration of the Bridge Design Pattern ===\n\n";
	Time *times[3];
	// Create instances of the parent class, and sub-classes of each of
	//   the Abstraction classes.
	cout << "Creating an instance of the parent Time class\n";
	times[0] = new Time(14, 30);
	cout << "Creating an instance of the CivilianTime sub-class\n";
	times[1] = new CivilianTime(2, 30, 1);
	cout << "Creating an instance of the ZuluTime sub-class\n";
	times[2] = new ZuluTime(14, 30, 6);
 	cout << "\n--------------- Getting the Times ----------------\n\n";
	cout << "Calling tell() in the Time class instance\n";
	times[0]->tell();
	cout << "Calling tell() in the CivilianTime class instance\n";
	times[1]->tell();
	cout << "Calling tell() in the ZuluTime class instance\n";
	times[2]->tell();
}

//---------------------------------------------------------------
// The Bridge is one of the harder Design Patterns to understand.
// According to the GoF the Bridge: "Decouples an abstraction
// from its implementation so the two can vary independently."
// The way the Bridge is implemented it is as if you are 
// separating a parent class which defines an interface (the
// abstraction classes) from its sub-classes which implement the
// interface (the implementation classes).
//
// In this example the class Time is the abstraction and it has
// two subclasses, CivilianTime and ZuluTime (Universal Time).
// These define a simple interface to the implementations.  The
// parent class of the implementations is TimeImp.  It has two
// subclasses, CivilianTimeImp and ZuluTimeImp. The abstraction
// classes each have a pointer to an instance of a TimeImp.
//
// In an application you create instances of the Time class
// or one of its subclasses. Each in turn creates an instance
// of the appropriate implementation class.  When you call
// a function in one of the abstraction classes it redirects
// the call to the appropriate functions in its' implementation
// class.
//---------------------------------------------------------------
