//=============================================================
// ProxyMain.cpp
// A demonstration of the Proxy design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMachine.h"
#include "GumballMachineProxy.h"
#include "GumballMonitor.h"
#include "GumballMonitorProxy.h"
#include <windows.h>  // for the Sleep() function
#include <iostream>

using namespace std;


void main()
{
	cout << "=== Demonstration of the Proxy Design Pattern ===\n\n";
	cout << "Initializing the simulation...\n";
	cout << "Creating a gumball monitor.\n";
	GumballMonitor *gbMon = new GumballMonitor();
	cout << "Creating a gumball machine proxy.\n";
	GumballMachineProxy *gbMacProx = new GumballMachineProxy();
	cout << "Creating a gumball monitor proxy.\n";
	GumballMonitorProxy *gbMonProx = new GumballMonitorProxy();
	cout << "Creating a gumball machine.\n";
	GumballMachine *gbMac = new GumballMachine();
	cout << "done...\n\n";
	Sleep(1000);
	cout << "Setting up all the links.\n";
	// Establish link from Monitor to Machine Proxy
	gbMon->setGumballMachine(gbMacProx);  // Actually the GB Monitor is connecting to the Proxy

	// Establish link from Machine Proxy via inherited fields from GumballProxy
	gbMacProx->setGumballMonitors(gbMon, gbMonProx); // to Real Monitor and Monitor Proxy
	gbMacProx->setGumballMachines(gbMac, gbMacProx); // to Machine Proxy and Real Machine
	// Establish link from Machine Proxy via inherited field from GumballMachine
	gbMacProx->setGumballMonitor(gbMonProx); // to Monitor Proxy

	// Establish link from Monitor Proxy via inherited fields from GumballProxy
	gbMonProx->setGumballMonitors(gbMon, gbMonProx); // to Real Monitor and Monitor Proxy
	gbMonProx->setGumballMachines(gbMac, gbMacProx); // to Machine Proxy and Real Machine
	// Establish link from Monitor Proxy via inherited field from GumballMonitor
	gbMonProx->setGumballMachine(gbMacProx); // to Machine Proxy

	// Extablish link from the Machine to Monitor Proxy
	gbMac->setGumballMonitor(gbMonProx);

	// Tell the monitor to run the simulation
	gbMon->RunDemo();
}