//=============================================================
// GumballProxy.h
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Proxy specific functions.
//  Both GumballMonitorProxy and GumballMachineProxy use
//  multiple inheritance to get these functions
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLPROXY_H
#define GUMBALLPROXY_H

#include "GumballMachine.h"
#include "GumballMonitor.h"

class GumballProxy
{
	protected:
		GumballMachine *realMachine; // The real machine this proxy is connected to
		GumballMachine *proxyMachine; // The proxy machine this proxy is connected to
		GumballMonitor *realMonitor; // The real monitor this proxy is connected to
		GumballMonitor *proxyMonitor; // The proxy monitor this proxy is connected to

	public:
		GumballProxy();									// Constructor
		~GumballProxy();								// Destructor
		void setGumballMachines(GumballMachine *gbMacReal,
								GumballMachine *gbMacProxy);  // Set the GBMachines
		void setGumballMonitors(GumballMonitor *gbMonReal,
								GumballMonitor *gbMonProxy);  // Set the GBMonitors
		virtual void ReceiveFromReal(char *msg);		// Receive a message from the real mon/mac
		virtual void SendToProxy(char *msg);			// Send a message to the proxy mon/mac
		virtual void ReceiveFromProxy(char *msg);		// Receive a message from the proxy mon/mac
		virtual void SendToReal(char *msg);			// Send a message to the real mon/mac
};

#endif