//=============================================================
// GumballMonitorProxy.h
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Monitor
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLMONITORPROXY_H
#define GUMBALLMONITORPROXY_H

#include "GumballMonitor.h"
#include "GumballProxy.h"

class GumballMonitorProxy : public GumballMonitor, public GumballProxy
{
	public:
		GumballMonitorProxy();				// Constructor
		~GumballMonitorProxy();				// Destructor
		//============== Functions inherited from GumballMonitor ===============
		bool Connect();					// Receive connection from the GBMac Proxy
		void ReceiveMessage(char *msg);	// Receive a message from the GBMac Proxy
		void Send_Message(char *msg);			// Send a messsage to the GBMac Proxy
		//============== Functions inherited from GumballProxy =================
		void ReceiveFromReal(char *msg);		// Receive a message from the real mon/mac
		void SendToProxy(char *msg);			// Send a message to the proxy mon/mac
		void ReceiveFromProxy(char *msg);		// Receive a message from the proxy mon/mac
		void SendToReal(char *msg);			// Send a message to the real mon/mac
};

#endif