//=============================================================
// GumballMachineProxy.h
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Machine Proxy
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLMACHINEPROXY_H
#define GUMBALLMACHINEPROXY_H

#include "GumballMachine.h"
#include "GumballProxy.h"

class GumballMachineProxy : public GumballMachine, public GumballProxy
{
	public:
		GumballMachineProxy();			// Constructor
		~GumballMachineProxy();			// Destructor
		//============== Functions inherited from GumballMachine ===============
		bool Connect();					// Connection is from the real GBMon
		void ReceiveMessage(char *msg);	// Receive a message from the GBMon
		void Send_Message(char *msg);	// Send a messsage to the GBMon
		//============== Functions inherited from GumballProxy =================
		void ReceiveFromReal(char *msg);// Receive a message from the real mon/mac
		void SendToProxy(char *msg);	// Send a message to the proxy mon/mac
		void ReceiveFromProxy(char *msg);// Receive a message from the proxy mon/mac
		void SendToReal(char *msg);		// Send a message to the real mon/mac
};

#endif