//=============================================================
// GumballMachineProxy.cpp
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Machine Proxy
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMachineProxy.h"
#include "GumballMonitorProxy.h"
#include "string"
#include <iostream>

using namespace std;

//-------------------------------------
// Constructor
//-------------------------------------
GumballMachineProxy::GumballMachineProxy()
{
}

//-------------------------------------
// Destructor
//-------------------------------------
GumballMachineProxy::~GumballMachineProxy()
{
}


//-------------------------------------------------------------------
// Accept a connection from a GumballMonitor.  This is the real
//		GumballMonitor.
// In this demonstration the GumballMachineProxy has a pointer to
//   the instance of GumballMonitorProxy.  In a real Proxy 
//   demonstration this function would establish a socket
//   connection with the remote GumballMonitorProxy
//-------------------------------------------------------------------
bool GumballMachineProxy::Connect()
{
	cout << "Gumball Machine Proxy: Connection accepted from the Gumball Monitor.\n";
	cout << "                       Establishing connection to Gumball Monitor Proxy.\n";
	theMonitor->Connect();
	return true;
}

//-------------------------------------
// Receive a message from the 
//	GumballMonitor
//-------------------------------------
void GumballMachineProxy::ReceiveMessage(char *msg)
{
	// Since any message coming in here is from the real GumballMonitor
	// pass it to the ReceiveFromReal() function for handling
	ReceiveFromReal(msg);
}

//-------------------------------------
// Send a messsage to the GBMon
//	GumballMonitorProxy
//-------------------------------------
void GumballMachineProxy::Send_Message(char *msg)
{
}

//============== Functions inherited from GumballProxy =================
//-----------------------------------------
// Receive a message from the real mon/mac
//-----------------------------------------
void GumballMachineProxy::ReceiveFromReal(char *msg)
{
	// Pass this to the send to proxy message
	cout << "GumballMachineProxy: Receiving message from GumballMonitor\n";
	SendToProxy(msg);
}

//-----------------------------------------
// Send a message to the proxy mon/mac
//-----------------------------------------
void GumballMachineProxy::SendToProxy(char *msg)
{
	// Using the connection between this proxy and the monitor proxy
	//   transfer the message
	cout << "GumballMachineProxy: Sending message to GumballMonitorProxy\n";
	((GumballMonitorProxy *)proxyMonitor)->ReceiveFromProxy(msg);
}

//-----------------------------------------
// Receive a message from the proxy mon/mac
//-----------------------------------------
void GumballMachineProxy::ReceiveFromProxy(char *msg)
{
	cout << "GumballMachineProxy: Message received from GumballMonitorProxy.\n";
	// Pass the message to the SendToReal function
	SendToReal(msg);
}

//-----------------------------------------
// Send a message to the real mon/mac
//-----------------------------------------
void GumballMachineProxy::SendToReal(char *msg)
{
	cout << "GumballMachineProxy: Sending message to GumballMonitor.\n";
	// Send this on to the real GumballMonitor
	this->realMonitor->ReceiveMessage(msg);
}