//=============================================================
// GumballMachine.h
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Machine
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLMACHINE_H
#define GUMBALLMACHINE_H

class GumballMonitor;	// Forward definition to avoid a circular include 

class GumballMachine
{
	protected:
		GumballMonitor *theMonitor;
		int m_iGumballCount;

	public:
		GumballMachine();						// Constructor
		~GumballMachine();						// Destructor
		void setGumballMonitor(GumballMonitor *gbm); // Set the GBMonProxy
		// The next three function are virtual to force run-time binding to the same
		//   functions in the GumballMachineProxy in the subclass
		virtual bool Connect();					// Connection is actually from the GBMon Proxy
		virtual void ReceiveMessage(char *msg);	// Receive a message from the GBMon
		virtual void Send_Message(char *msg);	// Send a messsage to the GBMon
};

#endif