//=============================================================
// GumballMachine.cpp
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Machine
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMachine.h"
#include "GumballMonitorProxy.h"
#include <string>
#include <iostream>

using namespace std;

//-------------------------------------
// Constructor
//-------------------------------------
GumballMachine::GumballMachine()
{
	m_iGumballCount = 20;
}

//-------------------------------------
// Destructor
//-------------------------------------
GumballMachine::~GumballMachine()
{
}

//-------------------------------------
// Set the GumballMonitor.  This is  
// actually the GumballMonitorProxy
//-------------------------------------
void GumballMachine::setGumballMonitor(GumballMonitor *gbm)
{
	theMonitor = gbm;
}

//-------------------------------------
// Accept a connection from a 
// GumballMonitor.  This is actually 
// from the GumballMonitorProxy
//-------------------------------------
bool GumballMachine::Connect()
{
	cout << "Gumball Machine: Connection accepted from the Gumball Monitor.\n";
	return true;
}

//-------------------------------------
// Receive a message from the 
//	GumballMonitorProxy
//-------------------------------------
void GumballMachine::ReceiveMessage(char *msg)
{
	cout << "GumballMachine: Message received from GumballMonitor.\n";
	// Parse and translate the message
	if(strcmp(msg, "Report") == 0)
	{
		// Tell the Monitor how many gumballs are left
		char *outMsg = new char[strlen("Gumballs remaining in the machine = ") + 4];
		sprintf(outMsg, "%s%d", "Gumballs remaining in the machine = ", m_iGumballCount);
		// Decrement the count
		m_iGumballCount-=5;
		if(m_iGumballCount < 0)
			m_iGumballCount = 0;
		cout << "GumballMachine: Sending report message to GumballMonitor.\n";
		this->Send_Message(outMsg);
	}
}


//-------------------------------------
// Send a messsage to the GBMon
//	GumballMonitorProxy
//-------------------------------------
void GumballMachine::Send_Message(char *msg)
{
	((GumballMonitorProxy *)theMonitor)->ReceiveFromReal(msg);
}

