//=============================================================
// StateMain.cpp
// A demonstration of the State design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMachine.h"
#include <iostream>

using namespace std;

#define numGumballs 3

void main()
{
	cout << "=== Demonstration of the State Design Pattern ===\n\n";
	cout << "Creating a gumball machine with " << numGumballs << " gumballs.\n\n";
	GumballMachine *gbm = new GumballMachine(numGumballs);

	// First action
	cout << "I'm inserting a quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "I'm turning the crank on the gumball machine.\n\t";
	gbm->turnCrank();
	cout << "...the gumball machine is being told to dispense a gumball.\n\t";
	gbm->dispense();
	cout << "I'm taking my gumball.\n\n";

	// Second action
	cout << "I'm inserting a second quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "I'm turning the crank on the gumball machine.\n\t";
	gbm->turnCrank();
	cout << "...the gumball machine is being told to dispense a gumball.\n\t";
	gbm->dispense();
	cout << "I'm taking my gumball.\n\n";

	// Do some illegal things
	cout << "OK, I'm going to try some dumb things.\n";
	cout << "I'm trying to turn the crank when I haven't inserted a quarter.\n\t";
	gbm->turnCrank();
	cout << "I'm telling the gumball machine to dispense without a quarter.\n\t";
	gbm->dispense();
	cout << "I'm trying to get my quarter ejected without inserting one.\n\t";
	gbm->ejectQuarter();
	cout << "I'm inserting a quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "Now, I'm trying to insert another quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "OK, let's eject the first quarter and start over.\n\t";
	gbm->ejectQuarter();
	cout << "\n\n";

	// Third action
	cout << "I'm inserting a third quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "I'm turning the crank on the gumball machine.\n\t";
	gbm->turnCrank();
	cout << "...the gumball machine is being told to dispense a gumball.\n\t";
	gbm->dispense();
	cout << "I'm taking my gumball.\n\n";

	// Fourth action
	cout << "I'm inserting a fourth quarter into the gumball machine.\n\t";
	gbm->insertQuarter();
	cout << "I'm turning the crank on the gumball machine.\n\t";
	gbm->turnCrank();
	cout << "...the gumball machine is being told to dispense a gumball.\n\t";
	gbm->dispense();
	cout << "Gee! I really wanted a gumball.\n\n";


}
