//=============================================================
// State.h
// A demonstration of the State design pattern in C++.  This is
//    the parent class for all states.
// Author: Dr. Rick Coleman
//=============================================================
#ifndef STATE_H
#define STATE_H

#include "GumballMachine.h"

class State
{
	protected:
		GumballMachine *gbm;

	public:
		State();
		State(GumballMachine *g);			// Constructor
		~State();							// Destructor
		virtual void insertQuarter();
		virtual void ejectQuarter();
		virtual void turnCrank();
		virtual void dispense();
};

#endif