//=============================================================
// State.cpp
// A demonstration of the State design pattern in C++.  This is
//    the parent class for all states.
// Author: Dr. Rick Coleman
//=============================================================
#include "State.h"

//-------------------------------------------------
// Constructor
// Note: This default constructor is required to
//   get a clean compile because of the forward
//	 definition of state used in GumballMachine.h
//	 This constructor is never used.
//-------------------------------------------------
State::State()
{
}

//------------------------------------------
// Constructor
//------------------------------------------
State::State(GumballMachine *g)
{
	gbm = g;
}

//------------------------------------------
// Destructor
//------------------------------------------
State::~State()
{
}

//------------------------------------------
// Handle the insert quarter state
//------------------------------------------
void State::insertQuarter()
{
}


//------------------------------------------
// Handle the eject quarter state
//------------------------------------------
void State::ejectQuarter()
{
}


//------------------------------------------
// Handle the turn crank state
//------------------------------------------
void State::turnCrank()
{
}


//------------------------------------------
// Handle the dispense gummball state
//------------------------------------------
void State::dispense()
{
}


