//=============================================================
// SoldState.h
// A demonstration of the State design pattern in C++.  
// Author: Dr. Rick Coleman
//=============================================================
#include "SoldState.h"
#include <iostream>
using namespace std;

//------------------------------------------
// Constructor
//------------------------------------------
SoldState::SoldState(GumballMachine *g)
{
	gbm = g;
}

//------------------------------------------
// Destructor
//------------------------------------------
SoldState::~SoldState()
{
}

//------------------------------------------
// Handle the insert quarter state
//------------------------------------------
void SoldState::insertQuarter()
{
	cout << "You can't inserted another quarter.\n";
}


//------------------------------------------
// Handle the eject quarter state
//------------------------------------------
void SoldState::ejectQuarter()
{
	cout << "Too late, can't return your quarter.\n";
	gbm->setState(gbm->getNoQuarterState());
}


//------------------------------------------
// Handle the turn crank state
//------------------------------------------
void SoldState::turnCrank()
{
	cout << "You already turned the crank.\n";
}


//------------------------------------------
// Handle the dispense gummball state
//------------------------------------------
void SoldState::dispense()
{
	cout << "Dispensing your gumball.\n";
	gbm->decrementGumballCount();
	if(gbm->getGumballCount() <= 0)
		gbm->setState(gbm->getSoldOutState());
	else
		gbm->setState(gbm->getNoQuarterState());
}
