//=============================================================
// SoldOutState.h
// A demonstration of the State design pattern in C++.  
// Author: Dr. Rick Coleman
//=============================================================
#include "SoldOutState.h"
#include <iostream>
using namespace std;

//------------------------------------------
// Constructor
//------------------------------------------
SoldOutState::SoldOutState(GumballMachine *g)
{
	gbm = g;
}

//------------------------------------------
// Destructor
//------------------------------------------
SoldOutState::~SoldOutState()
{
}

//------------------------------------------
// Handle the insert quarter state
//------------------------------------------
void SoldOutState::insertQuarter()
{
	cout << "Sorry, can't accept your quarter. There are no gumballs.\n";
}


//------------------------------------------
// Handle the eject quarter state
//------------------------------------------
void SoldOutState::ejectQuarter()
{
	cout << "Sorry, ejecting your quarter. There are no gumballs.\n";
}


//------------------------------------------
// Handle the turn crank state
//------------------------------------------
void SoldOutState::turnCrank()
{
	cout << "Sorry, you can't turn the crank. There are no gumballs.\n";
}


//------------------------------------------
// Handle the dispense gummball state
//------------------------------------------
void SoldOutState::dispense()
{
	cout << "Sorry, can't dispense. There are no gumballs.\n";
}
