//=============================================================
// NoQuarterState.h
// A demonstration of the State design pattern in C++.  
// Author: Dr. Rick Coleman
//=============================================================
#include "NoQuarterState.h"
#include <iostream>
using namespace std;

//------------------------------------------
// Constructor
//------------------------------------------
NoQuarterState::NoQuarterState(GumballMachine *g)
{
	gbm = g;
}

//------------------------------------------
// Destructor
//------------------------------------------
NoQuarterState::~NoQuarterState()
{
}

//------------------------------------------
// Handle the insert quarter state
//------------------------------------------
void NoQuarterState::insertQuarter()
{
	cout << "You inserted a quarter.\n";
	gbm->setState(gbm->getHasQuarterState());
}


//------------------------------------------
// Handle the eject quarter state
//------------------------------------------
void NoQuarterState::ejectQuarter()
{
	cout << "You haven't inserted a quarter.\n";
}


//------------------------------------------
// Handle the turn crank state
//------------------------------------------
void NoQuarterState::turnCrank()
{
	cout << "You turned but there's no quarter.\n";
}


//------------------------------------------
// Handle the dispense gummball state
//------------------------------------------
void NoQuarterState::dispense()
{
	cout << "You need to pay first.\n";
}
