//=============================================================
// HasQuarterState.h
// A demonstration of the State design pattern in C++.  
// Author: Dr. Rick Coleman
//=============================================================
#include "HasQuarterState.h"
#include "State.h"
#include <iostream>
using namespace std;

//------------------------------------------
// Constructor
//------------------------------------------
HasQuarterState::HasQuarterState(GumballMachine *g)
{
	gbm = g;
}

//------------------------------------------
// Destructor
//------------------------------------------
HasQuarterState::~HasQuarterState()
{
}

//------------------------------------------
// Handle the insert quarter state
//------------------------------------------
void HasQuarterState::insertQuarter()
{
	cout << "You can't inserted another quarter.\n";
}


//------------------------------------------
// Handle the eject quarter state
//------------------------------------------
void HasQuarterState::ejectQuarter()
{
	cout << "Quarter returned.\n";
	gbm->setState(gbm->getNoQuarterState());
}


//------------------------------------------
// Handle the turn crank state
//------------------------------------------
void HasQuarterState::turnCrank()
{
	cout << "You turned the crank.\n";
	gbm->setState(gbm->getSoldState());
}


//------------------------------------------
// Handle the dispense gummball state
//------------------------------------------
void HasQuarterState::dispense()
{
	cout << "You need to turn the crank first.\n";
}
