//=============================================================
// GumballMachine.h
// A demonstration of the State design pattern in C++. This
//	class defines the Gumball Machine
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLMACHINE_H
#define GUMBALLMACHINE_H

class State;	// Forward definition to avoid a circular include in State.h
				// See the note in the default constructor of State

class GumballMachine
{
	private:
		State *soldOutState;
		State *noQuarterState;
		State *hasQuarterState;
		State *soldState;
		State *state;
		int count;

	public:
		GumballMachine(int ct);		// Constructor
		~GumballMachine();			// Destructor
		void insertQuarter();
		void ejectQuarter();
		void turnCrank();
		void dispense();
		void setState(State *s);
		State *getSoldOutState();
		State *getNoQuarterState();
		State *getHasQuarterState();
		State *getSoldState();
		int getGumballCount();
		void decrementGumballCount();
};

#endif