//=============================================================
// GumballMachine.h
// A demonstration of the State design pattern in C++. This
//	class defines the Gumball Machine
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMachine.h"
#include "State.h"
#include "HasQuarterState.h"
#include "NoQuarterState.h"
#include "SoldOutState.h"
#include "SoldState.h"

//---------------------------------------
// Constructor
//---------------------------------------
GumballMachine::GumballMachine(int ct)
{
	hasQuarterState = new HasQuarterState(this);
	noQuarterState = new NoQuarterState(this);
	soldOutState = new SoldOutState(this);
	soldState = new SoldState(this);
	count = ct;
	if(count > 0)
		state = noQuarterState;
	else
		state = soldOutState;
}

//---------------------------------------
// Destructor
//---------------------------------------
GumballMachine::~GumballMachine()
{
	// Delete all the state objects
	delete soldOutState;
	delete noQuarterState;
	delete hasQuarterState;
	delete soldState;
}

//---------------------------------------
// Handle inserting a quarter
//---------------------------------------
void GumballMachine::insertQuarter()
{
	state->insertQuarter();
}


//---------------------------------------
// Handle ejecting a quarter
//---------------------------------------
void GumballMachine::ejectQuarter()
{
	state->ejectQuarter();
}


//---------------------------------------
// Handle turning the crank
//---------------------------------------
void GumballMachine::turnCrank()
{
	state->turnCrank();
}


//---------------------------------------
// Handle dispensing gumballs 
//---------------------------------------
void GumballMachine::dispense()
{
	state->dispense();
}


//---------------------------------------
// Set the current state of the machine
//---------------------------------------
void GumballMachine::setState(State *s)
{
	state = s;
}


//---------------------------------------
// Get the sold state object
//---------------------------------------
State *GumballMachine::getSoldOutState()
{
	return soldOutState;
}


//---------------------------------------
// Get the no quarter state object
//---------------------------------------
State *GumballMachine::getNoQuarterState()
{
	return noQuarterState;
}


//---------------------------------------
// Get the has quarter state object
//---------------------------------------
State *GumballMachine::getHasQuarterState()
{
	return hasQuarterState;
}


//---------------------------------------
// Get the sold state object
//---------------------------------------
State *GumballMachine::getSoldState()
{
	return soldState;
}

//---------------------------------------
// Get the number of gumballs left
//---------------------------------------
int GumballMachine::getGumballCount()
{
	return count;
}

//---------------------------------------
// Decrement the number of gumballs
//---------------------------------------
void GumballMachine::decrementGumballCount()
{
	count--;
	if(count < 0) count = 0;
}

