//======================================================================
// Waitress.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the waitress who must list all items in the menus.
// Author: Dr. Rick Coleman
//======================================================================
#include "Waitress.h"
#include <iostream>

//---------------------------------
// Constructor
//---------------------------------
Waitress::Waitress(vector<Menu *>menus)
{
   this->m_Menus = menus;
   m_sWName = "Flo";
}

//---------------------------------
// Destructor
//---------------------------------
Waitress::~Waitress()
{
}

//---------------------------------
// Print all the menus
//---------------------------------
void Waitress::printMenus()
{
	for(vector<Menu *>::iterator itr = m_Menus.begin(); itr != m_Menus.end(); itr++)
	{
		MenuIterator *mItr = (*itr)->getIterator();
		cout << "\nOn this menu we have...\n";
		printMenu(mItr);
	}
}

//---------------------------------
// Print a menu
//---------------------------------
void Waitress::printMenu(MenuIterator *itr)
{
   while(itr->hasNext())
   {
        MenuItem *menuItem = itr->getNext();
        menuItem->print();
   }
}

//---------------------------------
// Get the name of the waitress
//---------------------------------
string Waitress::getWaitressName()
{
	return m_sWName;
}