//======================================================================
// PancakehouseMenu.h
// Class for use in demonstrating the Composite Design Pattern.  The
//   pancake house keeps its menus in a linked list.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef PANCAKEHOUSEMENU_H
#define PANCAKEHOUSEMENU_H

#include "Menu.h"
#include "MenuItem.h"
#include "MenuIterator.h"

// Define a structure for use in building the menu
struct PCHItem
{
	MenuItem *theItem;		// Pointer to a MenuItem instance
	PCHItem *next;			// Pointer to next PCHItem
};

class PancakehouseMenu : public Menu
{
	private:
		PCHItem *head;					// Pointer to the head of the list

	public:
		PancakehouseMenu();				// Constructor
		~PancakehouseMenu();			// Destructor
		void addItem(MenuItem *item);	// Add an item to the menu
		MenuItem *getItem(int position);// Get the item at index position
		MenuIterator *getIterator();	// Get the iterator for this menu
};

#endif
