//======================================================================
// PancakehouseMenu.cpp
// Class for use in demonstrating the Iterator Design Pattern.  The
//   pancake house keeps its menus in a linked list.
// Author: Dr. Rick Coleman
//======================================================================
#include "PancakehouseMenu.h"
#include "PancakehouseMenuIterator.h"
#include <iostream>
using namespace std;

//-----------------------------------
// Constructor
//-----------------------------------
PancakehouseMenu::PancakehouseMenu()
{
	head = NULL;
}

//-----------------------------------
// Destructor
//-----------------------------------
PancakehouseMenu::~PancakehouseMenu()
{
	PCHItem *temp = head;
	while(head != NULL)
	{
		temp = temp->next;
		delete head;
		head = temp;
	}
}
		
//-----------------------------------
// Add an item to the menu
//-----------------------------------
void PancakehouseMenu::addItem(MenuItem *item)
{
	PCHItem *temp;
	PCHItem *newItem = new PCHItem();
	MenuItem *newMItem = new MenuItem();
	*newMItem = *item; // copy it
	newItem->theItem = newMItem;
	newItem->next = NULL;

	if(head == NULL)
	{
		head = newItem;
	}
	else
	{
		temp = head;
		while(temp->next != NULL) // add at end of the list
		{
			temp = temp->next;
		}
		temp->next = newItem;
	}
}

//-----------------------------------
// Get the item at index position
//-----------------------------------
MenuItem *PancakehouseMenu::getItem(int position)
{
	int pos = 0;
	PCHItem *temp = head;
	while(temp != NULL)
	{
		if(pos == position) // Is this the one we want?
		{
			return temp->theItem;
		}
		pos++;
		temp = temp->next;
	}
	return NULL;
}

//-----------------------------------
// Get the iterator for this menu
//-----------------------------------
MenuIterator *PancakehouseMenu::getIterator()
{
	return new PancakehouseMenuIterator(this);
}
