//======================================================================
// MenuItemIterator.h
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the individual MenuItem.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef MENUITEMITERATOR_H
#define MENUITEMITERATOR_H

#include "MenuIterator.h"
class MenuItem; 	// forward definition to avoid a circular include

class MenuItemIterator : public MenuIterator
{
	private:
		bool notAccessed;
		MenuItem *theItem;

	public:
		MenuItemIterator(MenuItem *m);	// Constructor
		~MenuItemIterator();			// Destructor
		bool hasNext();					// Return true if there is another item
		MenuItem *getNext();			// Return the next menu item
};

#endif