//======================================================================
// MenuItemIterator.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the individual MenuItem.
// Author: Dr. Rick Coleman
//======================================================================
#include "MenuItemIterator.h"
#include "MenuItem.h"
#include <iostream>
using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
MenuItemIterator::MenuItemIterator(MenuItem *m)
{
	notAccessed = true;
	theItem = m;
}

//--------------------------------------
// Destructor
//--------------------------------------
MenuItemIterator::~MenuItemIterator()
{
}

//--------------------------------------
// Return true if there is another item
//--------------------------------------
bool MenuItemIterator::hasNext()
{
	return notAccessed;
}

//--------------------------------------
// Get the next menu item
//--------------------------------------
MenuItem *MenuItemIterator::getNext()
{
	notAccessed = false;
	return theItem;
}
