//========================================================================
// MenuItem.h
// Class for use in demonstrating the Iterator Design Pattern
// Author: Dr. Rick Coleman
//========================================================================
#include "MenuItem.h"
#include "MenuItemIterator.h"
#include <string>
#include <iostream>

using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
MenuItem::MenuItem()
{
	strcpy(m_sName, "Unknown");
	strcpy(m_sDesc, "Unknown");
	m_bVegetarian = false;
}

//--------------------------------------
// Destructor
//--------------------------------------
MenuItem::~MenuItem()
{
}
				
//--------------------------------------
// Set the name of this item
//--------------------------------------
void MenuItem::setName(char *name)
{
	strcpy(m_sName, name);
}
	
//--------------------------------------
// Get the name of this item
//--------------------------------------
char *MenuItem::getName()
{
	return m_sName;
}
		
//--------------------------------------
// Set the description of this item
//--------------------------------------
void MenuItem::setDescription(char *d)
{
	strcpy(m_sDesc, d);
}

//--------------------------------------
// Get the description of this item
//--------------------------------------
char *MenuItem::getDescription()
{
	return m_sDesc;
}

//--------------------------------------
// Set the price of this item
//--------------------------------------
void MenuItem::setPrice(double p)
{
	m_dPrice = p;
}

//--------------------------------------
// Get the price
//--------------------------------------
double MenuItem::getPrice()
{
	return m_dPrice;
}

//--------------------------------------
// Set vegetarian flag
//--------------------------------------
void MenuItem::setVegetarian(bool v)
{
	m_bVegetarian = v;
}

//--------------------------------------
// Return vegetarian flag
//--------------------------------------
bool MenuItem::isVegetarian()
{
	return m_bVegetarian;
}

//--------------------------------------
// Print this menu item
//--------------------------------------
void MenuItem::print()
{
	cout << "   " << m_sName << " - " << m_sDesc;
	if(m_bVegetarian)
		cout << " (Vegetarian)";
	cout << "    $" << m_dPrice << endl;
}

//-----------------------------------
// Get the iterator for this MenuItem
//-----------------------------------
MenuIterator *MenuItem::getIterator()
{
	return new MenuItemIterator(this);
}

