//======================================================================
// DinerMenuIterator.h
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Diner menu.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef DINERMENUITERATOR_H
#define DINERMENUITERATOR_H

#include "MenuIterator.h"
class DinerMenu; 	// forward definition to avoit a circular include

class DinerMenuIterator : public MenuIterator
{
	private:
		int m_iNextIdx;
		DinerMenu *theMenu;

	public:
		DinerMenuIterator(DinerMenu *m);	// Constructor
		~DinerMenuIterator();				// Destructor
		bool hasNext();						// Return true if there is another item
		MenuItem *getNext();				// Return the next menu item
};

#endif