//======================================================================
// DinerMenuIterator.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Diner menu.
// Author: Dr. Rick Coleman
//======================================================================
#include "DinerMenuIterator.h"
#include "Dinermenu.h"
#include <iostream>
using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
DinerMenuIterator::DinerMenuIterator(DinerMenu *m)
{
	m_iNextIdx = 0;
	theMenu = m;
}

//--------------------------------------
// Destructor
//--------------------------------------
DinerMenuIterator::~DinerMenuIterator()
{
}

//--------------------------------------
// Return true if there is another item
//--------------------------------------
bool DinerMenuIterator::hasNext()
{
	return (theMenu->getItem(m_iNextIdx) != NULL);
}

//--------------------------------------
// Get the next menu item
//--------------------------------------
MenuItem *DinerMenuIterator::getNext()
{
	MenuItem *m = theMenu->getItem(m_iNextIdx);
	m_iNextIdx++;
	return m;
}
