//======================================================================
// DinerMenu.h
// Class for use in demonstrating the Composite Design Pattern.  The
//   diner keeps its menus in a hash table.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef DINERMENU_H
#define DINERMENU_H

#include "Menu.h"
#include "MenuItem.h"
#include "MenuIterator.h"

#define TABLESIZE 20

class DinerMenu : public Menu
{
	private:
		MenuItem m_Menu[TABLESIZE];			// Hash table of menu items
		int m_iNextIdx;					// Next "empty" index in the array

	public:
		DinerMenu();					// Constructor
		~DinerMenu();					// Destructor
		void addItem(MenuItem *item);	// Copy an item into the menu
		MenuItem *getItem(int position);// Get the item at index position
		MenuIterator *getIterator();	// Get the iterator for this menu

	private:
		int CalcHashIndex(char *name);	// Calculate a hash index
		int CalcDoubleHash(char *name);	// Calculate a double hash increment
};

#endif
