//======================================================================
// DinerMenu.cpp
// Class for use in demonstrating the Composite Design Pattern.  The
//   Diner keeps its menus in a hash table.
// Author: Dr. Rick Coleman
//======================================================================
#include "DinerMenuIterator.h"
#include "DinerMenu.h"
#include <math.h>
#include <iostream>
using namespace std;

//-----------------------------------
// Constructor
//-----------------------------------
DinerMenu::DinerMenu()
{
	m_iNextIdx = 0;
	// Set all items in the hash table to empty
	for(int i=0; i<TABLESIZE; i++)
		m_Menu[i].setName("----");
}

//-----------------------------------
// Destructor
//-----------------------------------
DinerMenu::~DinerMenu()
{
}
		
//-----------------------------------
// Add an item to the menu
//-----------------------------------
void DinerMenu::addItem(MenuItem *item)
{
	int hashIdx, dHash;
	hashIdx = CalcHashIndex(item->getName());
	dHash = CalcDoubleHash(item->getName());

	if(strcmp(m_Menu[hashIdx].getName(), "----") == 0)
	{
		// OK to use this index
		m_Menu[hashIdx] = *item; // Copy the item 
	}
	else // That slot is occupied find another
	{
		bool foundIt = false;
		while(!foundIt)
		{
			hashIdx += dHash;
			hashIdx %= TABLESIZE; // wrap if needed
			if(strcmp(m_Menu[hashIdx].getName(), "----") == 0) // Is this one OK?
			{
				// OK to use this index
				m_Menu[hashIdx] = *item; // Copy the item 
				return; // Exit now
			}
		}
	}
}

//-----------------------------------
// Get the item at index position
//-----------------------------------
MenuItem *DinerMenu::getItem(int position)
{
	int pos = 0; // Look for one at this position
	int idx = 0;
	bool foundIt = false;
	while(!foundIt)
	{
		if((pos == position) &&
			(strcmp(m_Menu[idx].getName(), "----") != 0)) // This is the one we want
		{
			return &m_Menu[idx];
		}
		else if(strcmp(m_Menu[idx].getName(), "----") != 0) // Got one here
		{
			pos++;
		}
		idx++;
		if(idx >= TABLESIZE)
			foundIt = true; // exit the loop to return NULL
	}
 	return NULL;
}

//-----------------------------------
// Get the iterator for this menu
//-----------------------------------
MenuIterator *DinerMenu::getIterator()
{
	return new DinerMenuIterator(this);
}

//-----------------------------------
// Calculate a hash index
//-----------------------------------
int DinerMenu::CalcHashIndex(char *name)
{
	// Calculate index with first 6 characters
	int idx = ((int)(((name[0]-'A') * pow(26.0, 6.0)) +
			    ((name[1]-'A') * pow(26.0, 5.0)) +
			    ((name[2]-'A') * pow(26.0, 4.0)) +
			    ((name[3]-'A') * pow(26.0, 3.0)) +
			    ((name[4]-'A') * pow(26.0, 2.0)) +
			    (name[5]-'A') )) % TABLESIZE;
	return idx;
}

//-----------------------------------
// Calculate a double hash increment
//-----------------------------------
int DinerMenu::CalcDoubleHash(char *name)
{
	// Calculate index with first 6 characters
	int idx = (int)(( ((name[0]-'A') * pow(26.0, 6.0)) +
			    ((name[1]-'A') * pow(26.0, 5.0)) +
			    ((name[2]-'A') * pow(26.0, 4.0)) +
			    ((name[3]-'A') * pow(26.0, 3.0)) +
			    ((name[4]-'A') * pow(26.0, 2.0)) +
			    (name[5]-'A') ) / TABLESIZE);
	return ((idx > 0) ? idx : 1);
}

