//=============================================================
// CompositeMain.cpp
// A demonstration of the Composite design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include "Waitress.h"
#include "Menu.h"
#include "MenuItem.h"
#include "PancakehouseMenu.h"
#include "CafeMenu.h"
#include "DinerMenu.h"

#include <iostream>

using namespace std;

void buildPancakehouseMenu(PancakehouseMenu *theMenu);
void buildCafeMenu(CafeMenu *theMenu);
void buildDinerMenu(DinerMenu *theMenu);
void buildMenuItem(MenuItem *theMenu);

void main()
{
	vector<Menu *> theMenus;

	cout << "=== Demonstration of the Composite Design Pattern ===\n\n";
	// Build the Pancakehouse menu
	PancakehouseMenu *phm = new PancakehouseMenu();
	buildPancakehouseMenu(phm);
	theMenus.push_back(phm);
	// Build the Cafe menu
	CafeMenu *cm = new CafeMenu();
	buildCafeMenu(cm);
	theMenus.push_back(cm);
	// Build the Diner menu
	DinerMenu *dm = new DinerMenu();
	buildDinerMenu(dm);
	theMenus.push_back(dm);
	// Build a single MenuItem
	MenuItem *mi = new MenuItem();
	buildMenuItem(mi);
	theMenus.push_back(mi);

	// Create Flo and give her the vector of menus
	Waitress *flo = new Waitress(theMenus);
	// Have Flo list everything
	cout << flo->getWaitressName() << ", would you please list all the menus?" << endl << endl;
	flo->printMenus();
	cout << "\n\nThank you, " << flo->getWaitressName() << endl << endl;
}

//----------------------------------------------------
// Build the Pancakehouse Menu for this demonstration
//----------------------------------------------------
void buildPancakehouseMenu(PancakehouseMenu *theMenu)
{
	MenuItem m;
	// Add item 1
	m.setName("Stack-O-3");
	m.setDescription("Stack of 3 Buttermilk pancakes with syrup");
	m.setVegetarian(true);
	m.setPrice(3.95);
	theMenu->addItem(&m);
	// Add item 2
	m.setName("Sausage Stack");
	m.setDescription("Stack of 3 Buttermilk pancakes with sausage");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 3
	m.setName("Bacon Stack");
	m.setDescription("Stack of 3 Buttermilk pancakes with bacon");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 4
	m.setName("Bacon-Eggs-Toast");
	m.setDescription("2 eggs cooked anyway, with bacon and toast");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 5
	m.setName("Sausage-Eggs-Toast");
	m.setDescription("2 eggs cooked anyway, with sausage and toast");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 6
	m.setName("Big Breakfast");
	m.setDescription("2 eggs, stack of 3 pancakes, with bacon or sausage");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
}

//----------------------------------------------------
// Build the Cafe Menu for this demonstration
//----------------------------------------------------
void buildCafeMenu(CafeMenu *theMenu)
{
	MenuItem m;
	// Add item 1
	m.setName("Double Burger Basket");
	m.setDescription("Two flame-broiled burgers with large fries");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 2
	m.setName("Chicken Finger Basket");
	m.setDescription("Large chicken fingers, slaw, fries.");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 3
	m.setName("Portabella Burger");
	m.setDescription("Grilled Portabella on bun");
	m.setVegetarian(true);
	m.setPrice(3.95);
	theMenu->addItem(&m);
	// Add item 4
	m.setName("Chef's Salad");
	m.setDescription("Mixed chopped veggies on lettuce base.");
	m.setVegetarian(true);
	m.setPrice(4.50);
	theMenu->addItem(&m);
	// Add item 5
	m.setName("Fish Sandwich");
	m.setDescription("Fried fish filet, slaw, on bun with special sauce");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 6
	m.setName("Steak Sandwich");
	m.setDescription("Grilled rib-eye sandwich, salad, and fries");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
}

//----------------------------------------------------
// Build the Diner Menu for this demonstration
//----------------------------------------------------
void buildDinerMenu(DinerMenu *theMenu)
{
	MenuItem m;
	// Add item 1
	m.setName("Chicken-fried Steak");
	m.setDescription("Chicken-fried steak with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
	// Add item 2
	m.setName("BBQ chicken");
	m.setDescription("1/2 chicken, tangy BBQ sauce, with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
	// Add item 3
	m.setName("Veggie Lunch");
	m.setDescription("Any 3 veggies, bread and dessert");
	m.setVegetarian(true);
	m.setPrice(3.95);
	theMenu->addItem(&m);
	// Add item 4
	m.setName("Super Veggie Lunch");
	m.setDescription("Any 4 veggies, bread and dessert");
	m.setVegetarian(true);
	m.setPrice(4.50);
	theMenu->addItem(&m);
	// Add item 5
	m.setName("Pork Chop Special");
	m.setDescription("2 grilled pork chops, with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 6
	m.setName("Rib-eye Special");
	m.setDescription("Grilled 8-oz steak, salad, baked potato, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
}

//----------------------------------------------------
// Build an individual MenuItem for this demonstration
//----------------------------------------------------
void buildMenuItem(MenuItem *theMenu)
{
	theMenu->setName("Chicken ToGo");
	theMenu->setDescription("1/2 Roast Chicken with 2 veggies, dessert");
	theMenu->setVegetarian(false);
	theMenu->setPrice(6.95);
}