//======================================================================
// CafeMenuIterator.h
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Cafe menu.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef CAFEMENUITERATOR_H
#define CAFEMENUITERATOR_H

#include "MenuIterator.h"
class CafeMenu; 	// forward definition to avoit a circular include

class CafeMenuIterator : public MenuIterator
{
	private:
		int m_iNextIdx;
		CafeMenu *theMenu;

	public:
		CafeMenuIterator(CafeMenu *m);		// Constructor
		~CafeMenuIterator();				// Destructor
		bool hasNext();						// Return true if there is another item
		MenuItem *getNext();				// Return the next menu item
};

#endif