//======================================================================
// CafeMenuIterator.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Cafe menu.
// Author: Dr. Rick Coleman
//======================================================================
#include "CafeMenuIterator.h"
#include "Cafemenu.h"
#include <iostream>
using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
CafeMenuIterator::CafeMenuIterator(CafeMenu *m)
{
	m_iNextIdx = 0;
	theMenu = m;
}

//--------------------------------------
// Destructor
//--------------------------------------
CafeMenuIterator::~CafeMenuIterator()
{
}

//--------------------------------------
// Return true if there is another item
//--------------------------------------
bool CafeMenuIterator::hasNext()
{
	return (theMenu->getItem(m_iNextIdx) != NULL);
}

//--------------------------------------
// Get the next menu item
//--------------------------------------
MenuItem *CafeMenuIterator::getNext()
{
	MenuItem *m = theMenu->getItem(m_iNextIdx);
	m_iNextIdx++;
	return m;
}
