//======================================================================
// CafeMenu.h
// Class for use in demonstrating the Composite Design Pattern.  The
//   cafe keeps its menus in an array.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef CAFEMENU_H
#define CAFEMENU_H

#include "Menu.h"
#include "MenuItem.h"
#include "MenuIterator.h"

class CafeMenu : public Menu
{
	private:
		MenuItem m_Menu[20];			// Array of menu items
		int m_iNextIdx;					// Next "empty" index in the array

	public:
		CafeMenu();						// Constructor
		~CafeMenu();					// Destructor
		void addItem(MenuItem *item);	// Copy an item into the menu
		MenuItem *getItem(int position);// Get the item at index position
		MenuIterator *getIterator();	// Get the iterator for this menu
};

#endif
