//======================================================================
// CafeMenu.cpp
// Class for use in demonstrating the Composite Design Pattern.  The
//   cafe keeps its menus in an array.
// Author: Dr. Rick Coleman
//======================================================================
#include "CafeMenuIterator.h"
#include "CafeMenu.h"
#include <iostream>
using namespace std;

//-----------------------------------
// Constructor
//-----------------------------------
CafeMenu::CafeMenu()
{
	m_iNextIdx = 0;
}

//-----------------------------------
// Destructor
//-----------------------------------
CafeMenu::~CafeMenu()
{
}
		
//-----------------------------------
// Add an item to the menu
//-----------------------------------
void CafeMenu::addItem(MenuItem *item)
{
	if(m_iNextIdx < 20) // still have room
	{
		m_Menu[m_iNextIdx] = *item; // Copy the item 
		m_iNextIdx++;
	}
}

//-----------------------------------
// Get the item at index position
//-----------------------------------
MenuItem *CafeMenu::getItem(int position)
{
	if(position < m_iNextIdx) // This index is OK.
	{
		return &m_Menu[position];
	}
	return NULL;
}

//-----------------------------------
// Get the iterator for this menu
//-----------------------------------
MenuIterator *CafeMenu::getIterator()
{
	return new CafeMenuIterator(this);
}

