//======================================================================
// Waitress.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the waitress who must list all items in the menus.
// Author: Dr. Rick Coleman
//======================================================================
#include "Waitress.h"
#include <iostream>

//---------------------------------
// Constructor
//---------------------------------
Waitress::Waitress(PancakehouseMenu *phm, CafeMenu *cm)
{
   this->pancakeHouseMenu=phm;
   this->cafeMenu = cm;
   m_sWName = "Flo";
}

//---------------------------------
// Destructor
//---------------------------------
Waitress::~Waitress()
{
}

//---------------------------------
// Print all the menus
//---------------------------------
void Waitress::printMenus()
{
   MenuIterator *phIterator = pancakeHouseMenu->getIterator();
   MenuIterator *cIterator = cafeMenu->getIterator();
   cout << "\nBREAKFAST MENU\n";
   printMenu(phIterator);
   cout << "\nLUNCH MENU\n";
   printMenu(cIterator);
}

//---------------------------------
// Print a menu
//---------------------------------
void Waitress::printMenu(MenuIterator *itr)
{
   while(itr->hasNext())
   {
        MenuItem *menuItem = itr->getNext();
        menuItem->print();
   }
}

//---------------------------------
// Get the name of the waitress
//---------------------------------
string Waitress::getWaitressName()
{
	return m_sWName;
}