//======================================================================
// PancakehouseMenuIterator.h
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Pancake House menu.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef PANCAKEHOUSEMENUITERATOR_H
#define PANCAKEHOUSEMENUITERATOR_H

#include "MenuIterator.h"
class PancakehouseMenu;	// forward definition to avoid a circular include

class PancakehouseMenuIterator : public MenuIterator
{
	private:
		int m_iNextIdx;
		PancakehouseMenu *theMenu;

	public:
		PancakehouseMenuIterator(PancakehouseMenu *m);		// Constructor
		~PancakehouseMenuIterator();						// Destructor
		bool hasNext();						// Return true if there is another item
		MenuItem *getNext();				// Return the next menu item
};

#endif