//======================================================================
// PancakehouseMenuIterator.cpp
// Class for use in demonstrating the Iterator Design Pattern.  This
//   is the iterator for the Pancake House menu.
// Author: Dr. Rick Coleman
//======================================================================
#include "PancakehouseMenuIterator.h"
#include "PancakehouseMenu.h"
#include <iostream>
using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
PancakehouseMenuIterator::PancakehouseMenuIterator(PancakehouseMenu *m)
{
	m_iNextIdx = 0;
	theMenu = m;
}

//--------------------------------------
// Destructor
//--------------------------------------
PancakehouseMenuIterator::~PancakehouseMenuIterator()
{
}

//--------------------------------------
// Return true if there is another item
//--------------------------------------
bool PancakehouseMenuIterator::hasNext()
{
	return (theMenu->getItem(m_iNextIdx) != NULL);
}

//--------------------------------------
// Get the next menu item
//--------------------------------------
MenuItem *PancakehouseMenuIterator::getNext()
{
	MenuItem *m = theMenu->getItem(m_iNextIdx);
	m_iNextIdx++;
	return m;
}
