//=============================================================
// IteratorMain.cpp
// A demonstration of the Iterator design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include "Waitress.h"
#include "PancakehouseMenu.h"
#include "CafeMenu.h"
#include <stdio.h>
#include <iostream>

using namespace std;

void buildPancakehouseMenu(PancakehouseMenu *theMenu);
void buildCafeMenu(CafeMenu *theMenu);

void main()
{
	cout << "=== Demonstration of the Iterator Design Pattern ===\n\n";
	PancakehouseMenu *phm = new PancakehouseMenu();
	buildPancakehouseMenu(phm);
	CafeMenu *cm = new CafeMenu();
	buildCafeMenu(cm);
	Waitress *flo = new Waitress(phm, cm);
	// Have Flo list everything
	cout << flo->getWaitressName() << ", would you please list all the menus?" << endl << endl;
	flo->printMenus();
	cout << "\n\nThank you, " << flo->getWaitressName() << endl << endl;

	cout << "\n\nPress enter to end this demonstation...";
	getchar();
}

//----------------------------------------------------
// Build the Pancakehouse Menu for this demonstration
//----------------------------------------------------
void buildPancakehouseMenu(PancakehouseMenu *theMenu)
{
	MenuItem m;
	// Add item 1
	m.setName("Stack-O-3");
	m.setDescription("Stack of 3 Buttermilk pancakes with syrup");
	m.setVegetarian(true);
	m.setPrice(3.95);
	theMenu->addItem(&m);
	// Add item 2
	m.setName("Sausage Stack");
	m.setDescription("Stack of 3 Buttermilk pancakes with sausage");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 3
	m.setName("Bacon Stack");
	m.setDescription("Stack of 3 Buttermilk pancakes with bacon");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 4
	m.setName("Bacon-Eggs-Toast");
	m.setDescription("2 eggs cooked anyway, with bacon and toast");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 5
	m.setName("Sausage-Eggs-Toast");
	m.setDescription("2 eggs cooked anyway, with sausage and toast");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 6
	m.setName("Big Breakfast");
	m.setDescription("2 eggs, stack of 3 pancakes, with bacon or sausage");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
}

//----------------------------------------------------
// Build the Cafe Menu for this demonstration
//----------------------------------------------------
void buildCafeMenu(CafeMenu *theMenu)
{
	MenuItem m;
	// Add item 1
	m.setName("Chicken-fried Steak");
	m.setDescription("Chicken-fried steak with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
	// Add item 2
	m.setName("BBQ chicken");
	m.setDescription("1/2 chicken, tangy BBQ sauce, with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
	// Add item 3
	m.setName("Veggie Lunch");
	m.setDescription("Any 3 veggies, bread and dessert");
	m.setVegetarian(true);
	m.setPrice(3.95);
	theMenu->addItem(&m);
	// Add item 4
	m.setName("Super Veggie Lunch");
	m.setDescription("Any 4 veggies, bread and dessert");
	m.setVegetarian(true);
	m.setPrice(4.50);
	theMenu->addItem(&m);
	// Add item 5
	m.setName("Pork Chop Special");
	m.setDescription("2 grilled pork chops, with 2 veggies, dessert");
	m.setVegetarian(false);
	m.setPrice(4.95);
	theMenu->addItem(&m);
	// Add item 6
	m.setName("Rib-eye Special");
	m.setDescription("8-oz rib-eye grilled, salad, baked potato, dessert");
	m.setVegetarian(false);
	m.setPrice(6.95);
	theMenu->addItem(&m);
}