//======================================================================
// Menu.h
// Class for use in demonstrating the Visitor Design Pattern.  The
//   parent class for all menus.
// Author: Dr. Rick Coleman
//======================================================================
#ifndef MENU_H
#define MENU_H

class Visitor;

#include "MenuItem.h"
#include <vector>
using namespace std;

class Menu
{
	private:
		vector<MenuItem *> m_vMenuItems;
		char m_sName[64];					// Name of the place using this menu

	public:
		Menu();								// Constructor
		~Menu();							// Destructor
		void setName(char *name);			// Set the name of this resturant
		char *getName();					// Get the name of this resturant
		// This function is to illustrate the Visitor Design Pattern
		void Accept(Visitor *v);			// Accept this visitor
		void AddItem(MenuItem *item);		// Add a MenuItem to the vector
};

#endif
