//======================================================================
// Menu.cpp
// Class for use in demonstrating the Visitor Design Pattern.  The
//   parent class for all menus.
// Author: Dr. Rick Coleman
//======================================================================
#pragma warning(disable:4996)

#include "Visitor.h"
#include "Menu.h"
#include <iostream>
#include <string.h>
using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
Menu::Menu()
{
}

//--------------------------------------
// Destructor
//--------------------------------------
Menu::~Menu()
{
}

//--------------------------------------
// Set the name of this resturant
//--------------------------------------
void Menu::setName(char *name)
{
	strcpy(m_sName, name);
}

//--------------------------------------
// Get the name of this resturant
//--------------------------------------
char *Menu::getName()
{
	return m_sName;
}

//--------------------------------------
// Accept this visitor and tell all
//    MenuItems to accept it.
//--------------------------------------
void Menu::Accept(Visitor *visitor)
{
	// Call the visitor for this Menu
	visitor->Visit(this);

	// Iterate through all ingredients and tell them to accept the visitor
	for(vector<MenuItem *>::iterator itr = m_vMenuItems.begin(); itr != m_vMenuItems.end(); itr++)
	{
		(*itr)->Accept(visitor); // Tell each MenuItem to accept this visitor
	}
}

//--------------------------------------
// Add a MenuItem to the vector
//--------------------------------------
void Menu::AddItem(MenuItem *item)
{
	m_vMenuItems.push_back(item);
}
