//======================================================================
// Ingredient.cpp
// Class for use in demonstrating the Visitor Design Pattern.  Defines
//   the ingredients used in all MenuItems
// Author: Dr. Rick Coleman
//======================================================================
#pragma warning(disable:4996)

#include "Visitor.h"
#include "Ingredient.h"
#include "String.h"

//---------------------------------------
// Constructor
//---------------------------------------
Ingredient::Ingredient()
{
}

//---------------------------------------
// Destructor
//---------------------------------------
Ingredient::~Ingredient()
{
}

//---------------------------------------
// Set the name of this ingredient
//---------------------------------------
void Ingredient::setName(char *name)
{
	strcpy(m_sName, name);
}

//---------------------------------------
// Get the name of this ingredient
//---------------------------------------
char *Ingredient::getName()
{
	return m_sName;
}

//---------------------------------------
// Set the amount in this ingredient
//---------------------------------------
void Ingredient::setAmount(double amount)
{
	m_dAmount = amount;
}

//---------------------------------------
// Get the amount
//---------------------------------------
double Ingredient::getAmount()
{
	return m_dAmount;
}

//---------------------------------------
// Set the measure used for this ingredient
//---------------------------------------
void Ingredient::setMeasure(MEASURE measure)
{
	m_Measure = measure;
}

//---------------------------------------
// Get the measure
//---------------------------------------
MEASURE Ingredient::getMeasure()
{
	return m_Measure;
}

//---------------------------------------
// Set the carbs in this ingredient
//---------------------------------------
void Ingredient::setCarbs(double carbs)
{
	m_dCarbs = carbs;
}

//---------------------------------------
// Get the carbs
//---------------------------------------
double Ingredient::getCarbs()
{
	return m_dCarbs;
}

//---------------------------------------
// Set the calories in this ingredient
//---------------------------------------
void Ingredient::setCalories(double calories)
{
	m_dCalories = calories;
}

//---------------------------------------
// Get the calories
//---------------------------------------
double Ingredient::getCalories()
{
	return m_dCalories;
}

//---------------------------------------
// Accept this visitor
//---------------------------------------
void Ingredient::Accept(Visitor *v)
{
	v->Visit(this);
}

