//==========================================================================
// HealthRatingVisitor.h
// Subclass of Visitor to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#ifndef	HEALTHRATINGVISITOR_H
#define HEALTHRATINGVISITOR_H

#include "Visitor.h" 

class HealthRatingVisitor : public Visitor
{
	private:
		double m_dCalCount;				// Running calorie count total for the current item
		double m_dCarbCount;			// Running carb count total for the current item

	public:
		HealthRatingVisitor();			// Constructor
		~HealthRatingVisitor();			// Destructor
		// This function is to illustrate the Visitor Design Pattern
		void Visit(Menu *menu);			// Visit this Menu
		void Visit(MenuItem *item);		// Visit this MenuItem
		void Visit(Ingredient *ing);	// Visit this Ingredient
};

#endif
