//==========================================================================
// HealthRatingVisitor.cpp
// Subclass of Visitor to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#include "HealthRatingVisitor.h" 
#include <iostream>
#include <iomanip>
using namespace std;

// Note: The HealthRatingVisitor knows all about the items it will visit.  It adds functionality
//       to each without having to modify the items.

//--------------------------------------
// Constructor
//--------------------------------------
HealthRatingVisitor::HealthRatingVisitor()
{
	m_dCalCount = 0;
	m_dCarbCount = 0;
}

//--------------------------------------
// Destructor
//--------------------------------------
HealthRatingVisitor::~HealthRatingVisitor()
{
}

//--------------------------------------
// Visit this Menu
//--------------------------------------
void HealthRatingVisitor::Visit(Menu *menu)
{
	// Print the name of the resturant
	cout << "Resturant: " << menu->getName() << endl;
	// Menu will now tell all of its MenuItems to call 
	//   the next Visit function.
}

//--------------------------------------
// Visit this MenuItem
//--------------------------------------
void HealthRatingVisitor::Visit(MenuItem *item)
{
	// Init the calorie and carb count total for this item
	m_dCalCount = 0;
	m_dCarbCount = 0;
	cout << "\tMenuItem: " << item->getName() << endl;
	cout << "\t\tDesc: " << item->getDescription() << endl;
	cout << "\t\tPrice: " << fixed << setprecision(2) << item->getPrice() << endl;
	cout << "\t\tIngredients:\n";
	// MenuItem will now tell all of its Ingredients to call 
	//   the next Visit function.
}

//--------------------------------------
// Visit this Ingredient
//--------------------------------------
void HealthRatingVisitor::Visit(Ingredient *ing)
{
	cout << "\t\t\tIngredient: " << ing->getName() << endl;
	cout << "\t\t\tAmount: " << ing->getAmount();
	MEASURE m = ing->getMeasure();
	if(m != UNIT)
	{
		switch(m)
		{
			case CUP: 
				cout << " cup(s)" << endl;
				break;
			case TABLESPOON: 
				cout << " Tablespoon(s)" << endl;
				break;
			case TEASPOON: 
				cout << " Teaspoon(s)" << endl;
				break;
			case OUNCE: 
				cout << " Ounce(s)" << endl;
				break;
		}
	}
	else
		cout << endl;
	double cals = ing->getCalories() * ing->getAmount(); // Calculate total calories
	cout << "\t\t\tCalories: " << cals << endl;
	m_dCalCount+=cals;
	cout << "\t\t\t\tTotal calories with this ingredient = " << m_dCalCount << endl;
	double carbs = ing->getCarbs() * ing->getAmount(); // Calculate total Carbs
	cout << "\t\t\tCarbs: " << carbs << " grams" << endl;
	m_dCarbCount+=carbs;
	cout << "\t\t\t\tTotal Carbs with this ingredient = " << m_dCarbCount << " grams" << endl;
	// Health rating based on 2500 calorie/day diet, and 
	//    limiting carbs to 377-346 (25-65 age range) for males, 301-265 (25-65 age range) for females
	double percentDailyCals = (m_dCalCount / 2500.0) * 100.0;
	double percentDailyCarbsM25 = (m_dCarbCount / 377.0) * 100.0;
	double percentDailyCarbsM65 = (m_dCarbCount / 346.0) * 100.0;
	double percentDailyCarbsF25 = (m_dCarbCount / 301.0) * 100.0;
	double percentDailyCarbsF65 = (m_dCarbCount / 265.0) * 100.0;
	cout << "\t\t\tTotal Health Rating including this ingredient: \n";
	cout << "\t\t\t\tBased on a 2500 calorie/day diet this is \n\t\t\t\t\t" 
		<< percentDailyCals << "% of your calories.\n";
	cout << "\t\t\t\tMales age 25 (377 grams/day) this is  \n\t\t\t\t\t" 
		<< percentDailyCarbsM25 << "% of your carbs.\n";
	cout << "\t\t\t\tMales age 65 (346 grams/day) this is  \n\t\t\t\t\t" 
		<< percentDailyCarbsM65 << "% of your carbs.\n";
	cout << "\t\t\t\tFemales age 25 (301 grams/day) this is  \n\t\t\t\t\t" 
		<< percentDailyCarbsF25 << "% of your carbs.\n";
	cout << "\t\t\t\tFemales age 65 (265 grams/day) this is  \n\t\t\t\t\t" 
		<< percentDailyCarbsF65 << "% of your carbs.\n";
}

