//==========================================================================
// CarbCountVisitor.h
// Subclass of Visitor to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#ifndef	CARBCOUNTVISITOR_H
#define CARBCOUNTVISITOR_H

#include "Visitor.h" 

class CarbCountVisitor : public Visitor
{
	private:
		double m_dCCount;				// Running Carb count total for the current item

	public:
		CarbCountVisitor();				// Constructor
		~CarbCountVisitor();			// Destructor
		// This function is to illustrate the Visitor Design Pattern
		void Visit(Menu *menu);			// Visit this Menu
		void Visit(MenuItem *item);		// Visit this MenuItem
		void Visit(Ingredient *ing);	// Visit this Ingredient
};

#endif
