//==========================================================================
// CalorieCountVisitor.cpp
// Subclass of Visitor to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#include "CalorieCountVisitor.h" 
#include <iostream>
#include <iomanip>
using namespace std;

// Note: The CalorieCountVisitor knows all about the items it will visit.  It adds functionality
//       to each without having to modify the items.

//--------------------------------------
// Constructor
//--------------------------------------
CalorieCountVisitor::CalorieCountVisitor()
{
	m_dCCount = 0;
}

//--------------------------------------
// Destructor
//--------------------------------------
CalorieCountVisitor::~CalorieCountVisitor()
{
}

//--------------------------------------
// Visit this Menu
//--------------------------------------
void CalorieCountVisitor::Visit(Menu *menu)
{
	// Print the name of the resturant
	cout << "Resturant: " << menu->getName() << endl;
	// Menu will now tell all of its MenuItems to call 
	//   the next Visit function.
}

//--------------------------------------
// Visit this MenuItem
//--------------------------------------
void CalorieCountVisitor::Visit(MenuItem *item)
{
	// Init the calorie count total for this item
	m_dCCount = 0;
	cout << "\tMenuItem: " << item->getName() << endl;
	cout << "\t\tDesc: " << item->getDescription() << endl;
	cout << "\t\tPrice: " << fixed << setprecision(2) << item->getPrice() << endl;
	cout << "\t\tIngredients:\n";
	// MenuItem will now tell all of its Ingredients to call 
	//   the next Visit function.
}

//--------------------------------------
// Visit this Ingredient
//--------------------------------------
void CalorieCountVisitor::Visit(Ingredient *ing)
{
	cout << "\t\t\tIngredient: " << ing->getName() << endl;
	cout << "\t\t\tAmount: " << ing->getAmount();
	MEASURE m = ing->getMeasure();
	if(m != UNIT)
	{
		switch(m)
		{
			case CUP: 
				cout << " cup(s)" << endl;
				break;
			case TABLESPOON: 
				cout << " Tablespoon(s)" << endl;
				break;
			case TEASPOON: 
				cout << " Teaspoon(s)" << endl;
				break;
			case OUNCE: 
				cout << " Ounce(s)" << endl;
				break;
		}
	}
	else
		cout << endl;
	double cals = ing->getCalories() * ing->getAmount(); // Calculate total calories
	cout << "\t\t\tCalories: " << cals << endl;
	m_dCCount+=cals;
	cout << "\t\t\t\tTotal calories with this ingredient = " << m_dCCount << endl;
}

