//=============================================================
// GumballProxy.cpp
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Proxy specific functions.
//  Both GumballMonitorProxy and GumballMachineProxy use
//  multiple inheritance to get these functions
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballProxy.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
GumballProxy::GumballProxy()
{
	realMachine = NULL;
	proxyMachine = NULL;
	realMonitor = NULL;
	proxyMonitor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
GumballProxy::~GumballProxy()
{
}

//------------------------------------
// Set the GBMachines
//------------------------------------
void GumballProxy::setGumballMachines(GumballMachine *gbMacReal,
								GumballMachine *gbMacProxy)
{
	realMachine = gbMacReal;
	proxyMachine = gbMacProxy;
}

//------------------------------------
// Set the GBMonitors
//------------------------------------
void GumballProxy::setGumballMonitors(GumballMonitor *gbMonReal,
								GumballMonitor *gbMonProxy)
{
	realMonitor = gbMonReal;
	proxyMonitor = gbMonProxy;
}


//-----------------------------------------
// Receive a message from the real mon/mac
//-----------------------------------------
void GumballProxy::ReceiveFromReal(char *msg)
{
}

//-----------------------------------------
// Send a message to the proxy mon/mac
//-----------------------------------------
void GumballProxy::SendToProxy(char *msg)
{
}

//-----------------------------------------
// Receive a message from the proxy mon/mac
//-----------------------------------------
void GumballProxy::ReceiveFromProxy(char *msg)
{
}

//-----------------------------------------
// Send a message to the real mon/mac
//-----------------------------------------
void GumballProxy::SendToReal(char *msg)
{
}