//=============================================================
// GumballMonitorProxy.cpp
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Monitor Proxy
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMonitorProxy.h"
#include "GumballMachineProxy.h"
#include "GumballMonitor.h"
#include <iostream>

using namespace std;

//-------------------------------------
// Constructor
//-------------------------------------
GumballMonitorProxy::GumballMonitorProxy()
{
}

//-------------------------------------
// Destructor
//-------------------------------------
GumballMonitorProxy::~GumballMonitorProxy()
{
}

//-------------------------------------------------------------------
// Accept a connection from a GumballMonitor.  This is the 
//		GumballMonitorProxy.
// In this demonstration the GumballMonitorProxy has a pointer to
//   the instance of GumballMachineProxy.  In a real Proxy 
//   demonstration this function would establish a socket
//   connection with the remote GumballMachineProxy
//-------------------------------------------------------------------
bool GumballMonitorProxy::Connect()
{
	cout << "Gumball Monitor Proxy: Connection accepted from the Gumball Machine Proxy.\n";
	cout << "                       Establishing connection to Gumball Machine.\n";
	realMachine->Connect();
	return true;
}

//-------------------------------------
// Receive a message from the 
//	GumballMonitorProxy
//-------------------------------------
void GumballMonitorProxy::ReceiveMessage(char *msg)
{
}

//-------------------------------------
// Send a messsage to the GBMon
//	GumballMonitorProxy
//-------------------------------------
void GumballMonitorProxy::Send_Message(char *msg)
{
}

//============== Functions inherited from GumballProxy =================
//-----------------------------------------
// Receive a message from the real mon/mac
//-----------------------------------------
void GumballMonitorProxy::ReceiveFromReal(char *msg)
{
	cout << "GumballMonitorProxy: Message received from GumballMachine.\n";
	SendToProxy(msg);
}

//-----------------------------------------
// Send a message to the proxy mon/mac
//-----------------------------------------
void GumballMonitorProxy::SendToProxy(char *msg)
{
	cout << "GumballMonitorProxy: Sending message to GumballMachineProxy.\n";
	// Pass the message from the real machine to the machine proxy
	((GumballMachineProxy *)proxyMachine)->ReceiveFromProxy(msg);
}

//-----------------------------------------
// Receive a message from the proxy mon/mac
//-----------------------------------------
void GumballMonitorProxy::ReceiveFromProxy(char *msg)
{
	// Pass to function to send message to the real machine
	cout << "GumballMonitorProxy: Message received from GumballMachineProxy.\n";
	SendToReal(msg);
}

//-----------------------------------------
// Send a message to the real mon/mac
//-----------------------------------------
void GumballMonitorProxy::SendToReal(char *msg)
{
	cout << "GumballMonitorProxy: Sending message to GumballMachine.\n";
	realMachine->ReceiveMessage(msg);
}