//=============================================================
// GumballMonitor.h
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Monitor
// Author: Dr. Rick Coleman
//=============================================================
#ifndef GUMBALLMONITOR_H
#define GUMBALLMONITOR_H

#include "GumballMachine.h"

class GumballMonitor
{
	protected:
		GumballMachine *theMachine;

	public:
		GumballMonitor();				// Constructor
		~GumballMonitor();				// Destructor
		void setGumballMachine(GumballMachine *gbm); // Set the GBMacProxy
		virtual bool Connect();					// Connection to the GBMac Proxy
		virtual void ReceiveMessage(char *msg);	// Receive a message from the GBMac Proxy
		virtual void Send_Message(char *msg);	// Send a messsage to the GBMac Proxy

		void RunDemo();							// Tell the monitor to run the simulation
};

#endif