//=============================================================
// GumballMonitor.cpp
// A demonstration of the Proxy design pattern in C++. This
//	class defines the Gumball Monitor
// Author: Dr. Rick Coleman
//=============================================================
#include "GumballMonitor.h"
#include "GumballMonitorProxy.h"
#include "GumballMachine.h"
#include "GumballMachineProxy.h"
#include <windows.h>  // for the Sleep() function
#include <iostream>

using namespace std;

//-------------------------------------
// Constructor
//-------------------------------------
GumballMonitor::GumballMonitor()
{
}

//-------------------------------------
// Destructor
//-------------------------------------
GumballMonitor::~GumballMonitor()
{
}

//-------------------------------------
// Set the GBMacProxy.  This Monitor
//   thinks it is the real BG Machine
//-------------------------------------
void GumballMonitor::setGumballMachine(GumballMachine *gbm)
{
	theMachine = gbm;
}

//-------------------------------------
// Accept a connection from a 
// GumballMonitor.  This is the real 
// GumballMonitor
//-------------------------------------
bool GumballMonitor::Connect()
{
	cout << "Gumball Machine: Connection accepted from the Gumball Monitor.\n";
//	gbm->ReceiveMessage("Connection accepted by Gumball Machine.");
	return true;
}

//-------------------------------------
// Receive a message from the 
//	GumballMonitorProxy
//-------------------------------------
void GumballMonitor::ReceiveMessage(char *msg)
{
	cout << "GumballMonitor: Message received from GumballMachine.\n";
	cout << "   Message is: " << msg << endl;
	// Any incoming message is a dynamically allocated char array 
	//	so this class has the responsibility of deleting it after 
	//  the message is printed.
	delete msg;
}


//-------------------------------------
// Send a messsage to the 
//	GumballMonitorProxy
//-------------------------------------
void GumballMonitor::Send_Message(char *msg)
{
	cout << "GumballMonitor: Sending message to GumballMachine\n";
	theMachine->ReceiveMessage(msg);
}

//-----------------------------------------
// Tell the monitor to run the simulation
//-----------------------------------------
void GumballMonitor::RunDemo()
{
	// Connect to the Gumball Machine (proxy)
	cout << "\nGumballMonitor: Establishing connection to Gumball Machine.\n";
	this->theMachine->Connect();
	cout << endl;
	Sleep(1000); // Pause for effect
	Send_Message("Report");
	cout << endl;
	Sleep(1000); // Pause for effect
	Send_Message("Report");
	cout << endl;
	Sleep(1000); // Pause for effect
	Send_Message("Report");
	cout << endl;
	Sleep(1000); // Pause for effect
	Send_Message("Report");
	cout << endl;
	Sleep(1000); // Pause for effect
	Send_Message("Report");

}
